<?php
/*--------------------------------------------------------------
   Label.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects;

use Webmozart\Assert\Assert;

class Label
{
    /**
     * @var string
     */
    private $value;
    
    
    /**
     * Constructor.
     */
    private function __construct(string $value)
    {
        Assert::stringNotEmpty($value);
        
        $this->value = $value;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(string $label): self
    {
        return new self($label);
    }
    
    
    /**
     * Return value.
     */
    public function value(): string
    {
        return $this->value;
    }
}